/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id:  $:

  Description:
    Definition file of the "Device/Reset" dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------

    2006-07-05  initial version

**************************************************************************************/

///////////////////////////////////////////////////////////////////////////////////////////
/// \file ResetDlg.h
///  Definition file of the "Device/Reset" dialog
///////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "hexedit.h"
#include "BaseDialog.h"
#include "afxwin.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// Device Reset Dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CResetDlg : public CBaseDialog
{
  DECLARE_DYNAMIC(CResetDlg)

public:
  CResetDlg(CWnd* pParent = NULL);   // standard constructor
  virtual ~CResetDlg();

  void ThreadFunction(void);
  void OnUpdateDevice(CCifXDeviceBase* pcDevice);

// Dialog Data
  enum { IDD = IDD_RESET };

protected:
  virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

  unsigned long   m_ulTimeout;      //!< Timeout for reset
  unsigned long   m_ulResetMode;    //!< Mode to pass to reset command
  unsigned long   m_ulResetParam;   //!< Extended Mode (Parameter) to pass to reset command

  CComboBox       m_cResetModeCtrl; //!< Reset mode combobox control
  CHexEdit        m_cResetParamCtrl;//!< Reset Parameer edit control

  DECLARE_MESSAGE_MAP()
public:
  virtual BOOL OnInitDialog();
  afx_msg void OnCbnSelchangeCbReset();
  afx_msg void OnEnKillfocusEdtTimeout();
  afx_msg void OnBnClickedBtnReset();
};
